<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserGroup extends Model 
{

    protected $table = 'user_group';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('id_user', 'id_group');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'id_user');
    }

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'id_group');
    }

}